﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    protected void dc_ContextLoad(object sender, EventArgs e) {
        ObrotyParams op = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
        checkObrotyPars(op);                        
        
        CoreModule cm = CoreModule.GetInstance(dc);        
        labelPieczatka.EditValue = cm.Config.Firma.Pieczątka.NazwaWieleLinii;
        labelSiedziba1.EditValue = cm.Config.Firma.AdresSiedziby.Linia1;
        labelSiedziba2.EditValue = cm.Config.Firma.AdresSiedziby.Linia2;
        labelNIP.EditValue = cm.Config.Firma.Pieczątka.NIP;
        labelFooter.EditValue = String.Format("{0:yyyy-MM-dd HH:mm}", Date.Now) + " &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; " + dc.Copyright;
        
        string magazyny = String.Empty;
        Array.ForEach<Magazyn>(op.Magazyny, mag => magazyny += mag + ", " );
        magazyny = magazyny.Trim(new char[] { ' ', ','});
        lbMagazyny.EditValue = magazyny;
    }

    private void checkObrotyPars(ObrotyParams pars) {
        if (pars == null)
            throw new ArgumentNullException("ObrotyParams pars");
        if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
            throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
    }
    
    
</script>

<HTML>
	<body>
		<form method="post" runat="server">
            <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
            &nbsp;&nbsp;&nbsp;&nbsp;<b>Stany magazynowe</b>
            <br>
            &nbsp;&nbsp;&nbsp;&nbsp;Magazyn(y):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <ea:DataLabel ID="lbMagazyny" runat="server" EncodeHTML="True">
            </ea:DataLabel>
            <br>
            &nbsp;&nbsp;&nbsp;&nbsp;Stan na dzień:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <ea:DataLabel ID="Datalabel1" runat="server" DataMember="ObrotyParams.DataStanu"
                EncodeHTML="True">
            </ea:DataLabel>
            <br>
            <small>----------------------------------------------------------------------------------------------------------------------------------</small><br>
            <ea:DataLabel ID="labelPieczatka" runat="server" EncodeHTML="True" LeftMargin="4">
            </ea:DataLabel>
            <br>
            <ea:DataLabel ID="labelSiedziba1" runat="server" EncodeHTML="True" LeftMargin="4">
            </ea:DataLabel>
            <br>
            <ea:DataLabel ID="labelSiedziba2" runat="server" EncodeHTML="True" LeftMargin="4">
            </ea:DataLabel>
            <br>
            <ea:DataLabel ID="labelNIP" runat="server" LeftMargin="4" Format="NIP: {0}"
                Bold="False">
            </ea:DataLabel>
            <br>
           <small>
            <ea:TextGrid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel">
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Width="14" Align="Left" DataMember="Kod" Caption="Towar|Kod" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwa" Total="Info" Caption="Towar|Nazwa" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Workers.StanMagazynu.StanZam&#243;wieńMagazynowych" Caption="Zam&#243;wienia|stan"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" Caption="Zam&#243;wienia|wartość" DataMember="Workers.StanMagazynu.WartośćZam&#243;wieńMagazynowych" Format="{0:n}" Total="Sum" Width="12"> </ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Workers.StanMagazynu.StanMagazynu" Caption="Magazyn|stan" ></ea:GridColumn>
					<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Workers.StanMagazynu.WartośćMagazynu" Total="Sum" Caption="Magazyn|wartość" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" Caption="Suma" DataMember="Workers.StanMagazynu.WartośćKsięgowaMagazynu" Format="{0:n}" Total="Sum" Width="12"> </ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Workers.StanMagazynu.StanMinus" Caption="Stan|minus"></ea:GridColumn>
				</Columns>
			</ea:TextGrid>
            </small>
                        
            <ea:DataLabel ID="labelFooter" runat="server" Align="Right" WidthChars="130" Bold="False"></ea:DataLabel>
            
        </form>
	</body>
</HTML>

